/**
* @file controller.h
* @brief FEPを使ったコントローラ受信部
*/
#ifndef CONTROLLER_H
#define CONTROLLER_H

#include "mbed.h"
//#include "pin_config.h"
#include <math.h>

#include "FEP.h"

#define M_PI 3.141592653589793
#define ADDR 203
#define FEP_SUCCESS 0
#define DATA_SIZE 6
#define STICK_DIVIDE 255.0
#define STICK_NEWTRAL 0.2
#define STICK_NORM_MAX 1.0

/**
* @brief FEPを使ったコントローラのクラス
*/
class Controller : public FEP
{
public :

    /**
    * @brief コンストラクタ
    */
    Controller();

    /**
     * @brief コンストラクタ
     * @param FEPtx FEPtx
     * @param FEPrx FEPrx
     * @param addr  address
     */
    Controller(PinName FEPtx, PinName FEPrx,int addr);

    /**
    * @brief メンバ変数にボタンのステートを格納
    */
    int receiveState();

    /**
     * ボタン1の状態を取得
     * @param  number button number
     * @return        status
     */
    bool getButton1(int number);

    /**
     * ボタン2の状態を取得
     * @param  number button number
     * @return        status
     */
    bool getButton2(int number);

    /**
     * スティックの値を取得
     * @param  number sticknumber(x, y, x, y)
     * @return        stick value
     */
    double getStick(int number);

    /**
     * スチィックの角度を取得
     * @param  number left...0 right...1
     * @return        radian
     */
    float getRadian(int number);

    /**
     * スティックの距離を取得
     * @param  number left..0 right..1
     * @return        norm
     */
    float getNorm(int number);

private :
    void setStick();

    char data[6];
    uint8_t fepTemp;

protected :
    bool button1[7];
    bool button2[6];
    double stick[4];
    double radian[2];
    double norm[2];
};

#endif//CONTROLLER_H
