#ifndef WHEEL_H
#define WHEEL_H

#include "mbed.h"

class Wheel {
public:

    /**
     * デフォルトコンストラクタ
     */
    Wheel();

    /**
     * コンストラクタ
     * @param radian 車輪角
     */
    Wheel(double radian);

    /**
     * コンストラクタ
     * @param radian   車輪角
     * @param distance 車輪距離
     */
    Wheel(double radian, double distance);

    /**
     * コピーコンストラクタ
     * @param a wheelmember
     */
    Wheel(const Wheel &a);

    /**
     * 代入演算子
     * @return wheeel member
     */
    Wheel &operator=(const Wheel &a);

    /**
     * 代入演算子
     * @return 計算結果
     */
    Wheel &operator=(double value);
    /**
     * 代入演算子
     * @return 計算結果
     */
    Wheel &operator=(float value);

    /**
     * キャスト演算子
     * @return 計算結果
     */
    operator double();

    /**
     * キャスト演算子
     * @return 計算結果
     */
    operator float();

    /**
     * 車輪の角度を設定
     * @param tRadian dadian
     */
    void setRadian(double tRadian);

    /**
     * 車輪の距離を設定
     * @param tDistance distance
     */
    void setDistance(double tDistance);

    /**
     * 出力値を設定
     * @param value output
     */
    void setOutput(double value);

    /**
     * 平行移動出力計算
     * @param  r     距離
     * @param  theta 角度
     * @return       出力値
     */
    double calculateShift(double r, double theta);

    /**
     * 回転移動出力計算
     * @param  X     回転中心X
     * @param  Y     回転中心Y
     * @param  value 回転量
     * @return       出力値
     */
    double calculateRotate(double X, double Y, double value);

    /**
     * 出力値を取得
     * @return 出力値(計算結果)
     */
    double getOutput();

private:
    double radian;
    double distance;
protected:
    double outputShift;
    double outputRotate;
    double output;
};

#endif
