#ifndef OMNI_WHEEL_H
#define OMNI_WHEEL_H

#include "mbed.h"
#include "wheel.h"

/**
 * 汎用オムニホイール駆動用クラス
 */
class OmniWheel {
public:


    Wheel *wheel;

    /**
     * デフォルトコンストラクタ
     */
    OmniWheel();

    /**
     * コンストラクタ
     * @param wheelNumber 車輪数
     */
    OmniWheel(int wheelNumber);

    /**
     * XY平行移動ベクトル、回転中心とモーメントで出力を計算
     * @param X      平行移動X
     * @param Y      平行移動Y
     * @param gX     回転中心座標X
     * @param gY     回転中心座標Y
     * @param moment 回転量
     */
    void computeXY(double X, double Y, double gX, double gY, double moment);

    /**
     * XY平行移動ベクトル、モーメントで出力を計算
     * @param X      平行移動X
     * @param Y      平行移動Y
     * @param moment 回転量
     */
    void computeXY(double X, double Y, double moment);

    /**
     * rθ平行移動ベクトル、回転中心とモーメントで出力を計算
     * @param r      平行移動スピード
     * @param theta  平行移動角度
     * @param gX     回転中心X
     * @param gY     回転中心Y
     * @param moment 回転量
     */
    void computeCircular(double r, double theta, double gX, double gY, double moment);

    /**
     * rθ平行移動ベクトル、モーメントで出力を計算
     * @param r      平行移動スピード
     * @param theta  平行移動角度
     * @param moment モーメント
     */
    void computeCircular(double r, double theta, double moment);
private:
    int wheelNumber;
protected:
};

#endif//OMNI_WHEEL_H
