#include "wheel.h"

Wheel::Wheel() :
    radian(0),
    distance(1.0)
{
}

Wheel::Wheel(double radian) :
    radian(radian),
    distance(1.0)
{
}

Wheel::Wheel(double radian, double distance) :
    radian(radian),
    distance(distance)
{
}

Wheel::Wheel(const Wheel &a) :
    radian(a.radian),
    distance(a.distance)
{
}

Wheel &Wheel::operator=(const Wheel &a)
{
    if(this != &a) {
        radian = a.radian;
        distance = a.distance;
    }
    return *this;
}

Wheel &Wheel::operator=(double value)
{
    setOutput(value);
    return *this;
}

Wheel &Wheel::operator=(float value)
{
    setOutput(value);
    return *this;
}

Wheel::operator double()
{
    return output;
}

Wheel::operator float()
{
    return float(output);
}

void Wheel::setRadian(double tRadian)
{
    radian = tRadian;
}

void Wheel::setDistance(double tDistance)
{
    distance = tDistance;
}

void Wheel::setOutput(double value)
{
    output = value;
}

double Wheel::calculateShift(double r, double theta)
{
    outputShift = sin(theta - radian) * r;
    return outputShift;
}

double Wheel::calculateRotate(double X, double Y, double value)
{
    outputRotate = fabs(X + tan(radian) * Y - cos(radian) - sin(radian) * tan(radian)) / hypot(1.0, tan(radian));
    outputRotate *= value;
    if(Y > 0) {
        if(Y > (-1 * (X - sin(radian) * tan(radian))) / tan(radian)) outputRotate *= -1;
    }
    if(Y < 0) {
        if(Y < (-1 * (X - sin(radian) * tan(radian))) / tan(radian)) outputRotate *= -1;
    }
    return outputRotate;
}

double Wheel::getOutput()
{
    return output;
}
