#include "mbed.h"
#include "omni.h"

Omni omni(4);
Serial pc(USBTX, USBRX);

int main() {
    omni.setWheelRadian(M_PI / 3.0 * 1, M_PI / 3.0 * 2, M_PI / 3.0 * 4, M_PI / 3.0 * 5);
    
    while(1) {
        omni.computeXY(0.0, 1.0, 0);
        
        for(int i = 0; i < 4; i++) {
            pc.printf("%d: %.4f, ", i, omni.getOutput(i));
        }
        pc.printf("\n\r");
    }
}
