/**
 * @file omni.h
 * @author keitaro takeuchi
 *
 * @section DESCRIPTION
 * 3or4wheels omni libraryfor NHK2017.
 */
#ifndef OMNI_H
#define OMNI_H

/**
 * Includes
 */
#include "mbed.h"

/**
 * Defines
 */
#define M_PI 3.141592653589793

/**
 * omni wheel
 */
class Omni {
public :

    /**
     * Constructor.
     *
     * @param wheels 車輪数(3or4)
     */
    Omni(int wheels);
    
    /**
     * ホイールの付いている角度を設定
     *
     * @param rad radian
     * @param wheelNumber 番目のホイール
     */
    bool setWheelRadian(float rad1, float rad2, float rad3);
    bool setWheelRadian(float rad1, float rad2, float rad3, float rad4);
    bool setWheelRadian(int wheelNumber, float rad);
    
    /**
     * 位置ベクトル(x, y), 回転量から出力を計算
     *
     * @param X(-1 ~ 1)
     * @param Y(-1 ~ 1)
     * @param moment 回転量(-1 ~ 1)
     *
     * @return 1...success 0...failure
     */
    bool computeXY(float X, float Y, float moment);
    
    /**
     * 半径, 角度radian(r, Θ), 回転量から出力を計算
     *
     * @param r 半径(0 ~ 1)
     * @param rad radian(-PI ~ PI)
     * @param moment 回転量(-1 ~ 1)
     * @return 1...success 0...failure
     */
    bool computeCircular(float r, float rad, float moment);
    
    /**
     * 出力値を取得
     *
     * @param wheelNumber wheel番目のホイールの出力を設定
     *
     * @return 出力値
     */
    float getOutput(int wheelNumber);
private :
protected :
    int wheels;
    float wheel[4];
    float radian[4];
};

#endif//OMNI_H