#include "ikarashiMDC.h"


ikarashiMDC::ikarashiMDC(DigitalOut* serialcontrol,uint8_t taddr,uint8_t tmotorNum,bool tmode,Serial *tserial)
{
    serialControl = serialcontrol;
    serialControl->write(true);
    serial = tserial;
    addr = taddr;
    motorNum = tmotorNum;
    mode = tmode;
    braking = true;
}

int ikarashiMDC::setSpeed(const double& speed)
{
    uint8_t data[4],dataSpeed;
    //Limiter
    const double cropped_speed = std::min(1.0,std::max(-1.0,speed));
    //dataspeed 0~253 neutaral 126
    dataSpeed = ((cropped_speed+1.0)/2.0)*253;
    //printf("%d\n",dataSpeed);
    //set sending data
    data[0] = 255; //header
    data[1] = (addr<<5) + motorNum + (mode<<4)+(braking<<3); //address
    data[2] = dataSpeed;
    data[3] = data[1]^data[2];
    //send data
    for(int i=0; i<4; i++) {
        serial->putc(data[i]);
    }
    return 0;
}


void estop(Serial *serial)
{
    for(int i = 0; i<3; i++) {
        serial->putc(255);
    }

}
