/** @author 五十嵐幸多
 *
 * 割と簡単にCAN通信ができるクラスです。
 * 通信初心者なので何かあったら、すぐ五十嵐へGO
 */
#ifndef IKARASHI_CAN

#define IKARASHI_CAN

#include "mbed.h"
#include "DataControl.h"

/*サンプルコード
２台のCANを使って通信するヤツです。


#include "mbed.h"
#include "ikarashiCAN.h"

Serial pc(USBTX,USBRX,115200);
InterruptIn button(USER_BUTTON);
Ticker ticker;

//ikarashiCAN ican1(D15, D14, 1, 50000); //sender
ikarashiCAN ican1(D15, D14, 1); //sender
ikarashiCAN ican2(D4, D10, 2, 50000); //reciever

uint16_t data = 0;
//bool btnFlag = 0;

void pushed(){
    //btnFlag = !btnFlag;
    data+=12;
}

void can_update(){
    ican2.recieve();
    ican1.setData(data);
}

int main()
{

    ican1.startSend(0.1);
    
    button.mode(PullDown);
    
    while(1){
        button.fall(&pushed);
        can_update();
        pc.printf("sdata: %d  rdata: %d  len: %d  s: %d  r: %d\n\r", data,ican2.simpleGetData(1), ican2.CanLen(), ican1.checkSender(), ican2.checkReciever());
    }

}

*/


/// CAN通信のクラスです
class ikarashiCAN : public DataControl
{
public:

    /** コンストラクタ
     *
     * @param rd CANのrdピン
     * @param td CANのtdピン
     * @param msgID CANのID  
     * @param frequency CANの周波数
     * @note nucleoでやる場合、frequencyは50000にしないとなぜか安定しません。
     *       なので、frequencyを設定しなかったとき自動的に周波数が50000に設定されるようにしました。
     *       
     */
    ikarashiCAN(PinName rd, PinName td, int msgID, int frequency);
    ikarashiCAN(PinName rd, PinName td, int msgID);
    
    /** 送信するデータをセットする関数
     *
     * 一度送信するデータをセットします。
     * @typedef T 一旦値を保持するための型
     * @param _data 一旦値を保持する変数
     */
    template <class T>
    void setData(T _data){
        dataSet(_data, sender);
    }

    /** データを受け取る関数
     *
     * 受信したデータを返します。
     * @return int 受信したデータ
     */
    int getData();
    
    /** お手軽関数
     *
     * ほんとは色々処理を実行してからデータを取得しなきゃなんですけど、めんどくさいですよね！
     * なので、簡単に受信したデータを取得できる関数を用意しました。
     * 特定のIDのデータを取得できます。
     * @param _id 受信したいCANのID
     * @return int 受信したデータ
     */
    int simpleGetData(int _id);
    
    int simpleGetData();

    ///セットしたデータを送信します。
    void send();

    ///データを受信します。データの取得とは違います。
    void recieve();

    /** attach関数
     *
     * send関数のattachバージョン。
     * @param second 繰り返す間隔。単位は[s]
     */
    void startSend(float second);
    
    /** attach関数
     *
     * recieve関数のattachバージョン。データが送信されたときに自動で受信します。
     * @attention mbed-os5以上だとバグるみたいです。mbed2を使うか、素のrecieve関数を使ってください
     */
    void startRecieve();
    
    /** オリジナル
     *
     * 引数の値を送信用配列にセットします。この値は下のGet関数で取得できます。
     * 受信データの判別に使えるかも
     * @param free_num unsigned short型　
     */
    void originalSet(unsigned short free_num);
    
    /** オリジナルのセット
     *
     * @return int originalSetでセットした値
     */
    int originalGet();
    
    void ifOriginalGet(int &buff, int original_num);
    
    void ifOriginalGet(uint8_t &buff, int original_num);
    
    void ifOriginalGet(int16_t &buff, int original_num);
    
    ///データの送信が成功したときにtrueになります。
    bool checkSender();
    
    ///データの受信に成功したときにtrueになります。
    bool checkReciever();
    
    ///受信したデータのIDを返します。取得に失敗したときは-1を返します。
    int recievedCanID();
    
    ///このクラスを適用しているCANのIDを返します。
    int myCanID();
    
    ///受信したデータのサイズ(byte)を返します。
    int CanLen();


    void sender_reset();
    void reciever_reset();

    
private:

    CAN can;
    CANMessage msg;
    int _msgID;
    int sended_msgID;
    
    Ticker can_ticker;
    
    ///送信するデータの配列
    char sender[5];
    
    ///受信したデータが格納される配列
    char reciever[5];
    
    int _can_data;
    bool can_s;
    bool can_r;

};

#endif

