
#include "ikarashiCAN.h"

ikarashiCAN::ikarashiCAN(PinName rd, PinName td, int msgID, int frequency):
    can(rd, td, frequency), msg(msgID, reciever, 5)
{
    _msgID = msgID;
    sended_msgID = 0;
    can_s = 0;
    can_r = 0;
    _can_data = 0;
}

ikarashiCAN::ikarashiCAN(PinName rd, PinName td, int msgID):
    can(rd, td, 50000), msg(msgID, reciever, 5)
{
    _msgID = msgID;
    sended_msgID = 0;
    can_s = 0;
    can_r = 0;
    _can_data = 0;
}

//----------------------bit controll------------------------
int ikarashiCAN::getData()
{
    return dataCombine(msg.data, msg.len);
}
//--------------------------------------------------------//



//---attach function---------------------------------------//
void ikarashiCAN::send()
{
    can_s = 0;
    if(can.write(CANMessage(_msgID, sender, separated_data_size))) {
        can_s = 1;
    }
}

void ikarashiCAN::recieve()
{
    can_r = 0;
    if(can.read(msg)) {
        can_r = 1;
    }
}
//--------------------------------------------------------//



//---attach-----------------------------------------------//
void ikarashiCAN::startSend(float second)
{
    can_ticker.attach(this, &ikarashiCAN::send, second);
}

void ikarashiCAN::startRecieve()
{
    can_ticker.attach(this, &ikarashiCAN::recieve, CAN::TxIrq);
}
//--------------------------------------------------------//


int ikarashiCAN::simpleGetData(int _id)
{
    if(_id == msg.id && can_r) {
        _can_data = getData();
    }
    return _can_data;
}

int ikarashiCAN::simpleGetData()
{
    if(can_r) {
        _can_data = getData();
    }
    return _can_data;
}


bool ikarashiCAN::checkSender()
{
    return can_s;
}

bool ikarashiCAN::checkReciever()
{
    return can_r;
}

int ikarashiCAN::recievedCanID()
{
    if(can_r) {
        return msg.id;
    } else {
        return -1;
    }
}

int ikarashiCAN::myCanID()
{
    return _msgID;
}

int ikarashiCAN::CanLen()
{
    return msg.len;
}

void ikarashiCAN::originalSet(unsigned short free_num)
{
    sender[separated_data_size-1] = free_num;
}

int ikarashiCAN::originalGet()
{
    return msg.data[msg.len-1];
}

/*
void ikarashiCAN::ifOriginalGet(int &buff, int id, int original_num)
{
    if(id == msg.id && can_r && originalGet() == original_num) {
        buff = originalGet();
    }
}
*/

void ikarashiCAN::ifOriginalGet(int &buff, int original_num)
{
    if(originalGet() == original_num) {
        buff = simpleGetData();
    }
}

void ikarashiCAN::ifOriginalGet(uint8_t &buff, int original_num){
    if(originalGet() == original_num) {
        buff = simpleGetData();
    }
}

void ikarashiCAN::ifOriginalGet(int16_t &buff, int original_num){
    if(originalGet() == original_num) {
        buff = simpleGetData();
    }
}

void ikarashiCAN::sender_reset()
{
    for(int i=0; i<5; i++) sender[i] = 0;
}

void ikarashiCAN::reciever_reset()
{
    for(int i=0; i<5; i++) reciever[i] = 0;
}



