#ifndef HAYATOBOOMERANG_H
#define HAYATOBOOMERANG_H

#include "mbed.h"
#include "ikarashiMDC.h"
#include "PID.h"
#include "QEI.h"
#include "Spiral.h"
#include "pinConfig.h"
#include "omni.h"

#define DEG_TO_RAD 0.017453292519943295769236907684886
#define RAD_TO_DEG 57.295779513082320876798154814105

#define radians(deg) ((deg)*DEG_TO_RAD)
#define degrees(rad) ((rad)*RAD_TO_DEG)

class boomerang
{
public:
  boomerang(Serial *serail_,Serial *serial2_); // Create boomerang instance
  bool fire(); // Fire boomerang
  void setTargetMotorSpeed(const int& targetRPM);
  void setTargetArmAngle(const int& targetArmAngle); // 0 to 90
  int calibrateArm();
  void update();
  double motorRPM;
  double armAngle;
  bool calibrating;
  double beltSpeed;
  void move(const uint8_t& x,const uint8_t& y,const float& moment);
private:
  QEI *armEncoder;
  ikarashiMDC* armMotor,*shootingMotor,*beltMotor,*spiralMotor;
  ikarashiMDC *omniMotor[4];
  InterruptIn *speedEncoder;
  InterruptIn* armLimit;
  DigitalOut *rscs;
  PID *speedPID,*armPID;
  Timer rpmCalc;
  Spiral* spiral;
  Omni *omni;
  Serial *spiralSerial;

  void shootingEncoderCount();


};


#endif /* end of include guard: HAYATOBOOMERANG_H */
