#include "gakugaku.h"


gakugaku::gakugaku(Serial* serial_)
{
  rscs = new DigitalOut(NC);
  swingMotor = new ikarashiMDC(rscs,0,2,SM,serial_);
  angleMotor = new ikarashiMDC(rscs,0,3,SM,serial_);
  deploy = new DigitalOut(PC_0);

  angleMotor->setSpeed(0);
  swingMotor->setSpeed(0);

  anglingSpeed = 0;
  swinging = false;
  deploy->write(false);

}

void gakugaku::update()
{
  if (swinging) {
      swingMotor->setSpeed(0.5);
  } else {
      swingMotor->setSpeed(0);
  }
  angleMotor->setSpeed(anglingSpeed);
}

void gakugaku::setAnglingSpeed(const double& anglingSpeed_)
{
  anglingSpeed=anglingSpeed_;
}

void gakugaku::toggleSwing()
{
  swinging = !swinging;
}
void gakugaku::Deploy()
{
  deploy->write(true);
  timer.attach(callback(this,&gakugaku::deployStop),2);
}
void gakugaku::deployStop()
{
  deploy->write(false);
}
