#include "Spiral.h"

Spiral::Spiral(ikarashiMDC *spiralMotor_)
{
  beltSpeed = 0;
  spiralSpeed = 0;
  spiralMotor = spiralMotor_;
  spiralLimit = new InterruptIn(PB_12);
  spiralLimit->mode(PullUp);
  spiralLimit->rise(this,&Spiral::stopRotation);
  rotating = false;
  firing = false;
  spiralLimit->enable_irq();
}

int Spiral::rotate()
{
  if(rotating)
    return 1;
  spiralSpeed=-.5;
  spiralMotor->setSpeed(-.5);
  rotating = true;
  firing = true;
  return false;
}

void Spiral::stopRotation()
{
  if (!rotating)return;
  spiralSpeed=0;
  spiralMotor->setSpeed(0);
  rotating = false;
  beltTime.attach(callback(this,&Spiral::beltStart),0.1);
}

void Spiral::beltStart()
{
  beltSpeed=-1;
  beltTime.attach(callback(this,&Spiral::beltStop),0.1);
}
void Spiral::beltStop(){
  beltSpeed=0;
  firing = false;
}
