#ifndef TFMINI_H
#define TFMINI_H

#include "mbed.h"

#define TF_SERIAL_BUFFER_SIZE 9
#define TF_HEADER_FIRST_BYTE 0x59
#define TF_HEADER_SECOND_BYTE 0x59
#define TF_DEFAULT_BAUD 115200

class TFmini : public RawSerial
{
public :
    TFmini(PinName serialTX, PinName serialRX);

    int getDistance();
    int getStrength();

private :    
    void receiveByte();
    void checkData();
    void assemble();
    
    int distance;
    int strength;
    uint8_t reserved;
    uint8_t rawQual;

    uint8_t buffer[TF_SERIAL_BUFFER_SIZE];
    uint8_t data[TF_SERIAL_BUFFER_SIZE - 3];
    //uint8_t mask;
    uint8_t bufferPoint;
    uint8_t receivedBytes;
    
};

#endif
