#include "TFmini.h"

TFmini::TFmini(PinName serialTX, PinName serialRX) :
    RawSerial(serialTX, serialRX, TF_DEFAULT_BAUD)
{
    attach(callback(this, &TFmini::receiveByte));
}

void TFmini::receiveByte()
{
    buffer[bufferPoint % TF_SERIAL_BUFFER_SIZE] = getc();
 
    if(bufferPoint != 0xff) {
        ++bufferPoint;
    } else {
        bufferPoint = (255 % TF_SERIAL_BUFFER_SIZE)+1;
    }
 
    ++receivedBytes;
 
    if(receivedBytes >= TF_SERIAL_BUFFER_SIZE){
        checkData();
    }
}
void TFmini::checkData()
{
    for(int i = 0; i < TF_SERIAL_BUFFER_SIZE; i++) {
        if(buffer[i % TF_SERIAL_BUFFER_SIZE] == TF_HEADER_FIRST_BYTE && buffer[(i + 1) % TF_SERIAL_BUFFER_SIZE] == TF_HEADER_SECOND_BYTE) {
            uint8_t checksum = 0x00;
            for(int j = 0; j < TF_SERIAL_BUFFER_SIZE - 1; j++) {
                checksum += buffer[(i + j)% TF_SERIAL_BUFFER_SIZE];
            }
            if(checksum == buffer[(i + TF_SERIAL_BUFFER_SIZE - 1)% TF_SERIAL_BUFFER_SIZE]) {
                for(int j = 0; j < TF_SERIAL_BUFFER_SIZE - 3; j++) {
                    data[j] = buffer[(i + 2 + j) % TF_SERIAL_BUFFER_SIZE];
                }
                receivedBytes = 0;
 
                assemble();
                return;
            }
        }
    }
}

void TFmini::assemble()
{
    distance = (data[0] & 0xFF) | ((data[1] << 8) & 0xFF00);
    strength = (data[2] & 0xFF) | ((data[3] << 8) & 0xFF00);
    reserved = data[4];
    rawQual = data[5];
}

int TFmini::getDistance()
{
    return distance;
}

int TFmini::getStrength()
{
    return strength;
}
