
#ifndef SEKIKIKOU

#define SEKIKIKOU

#include "mbed.h"
#include "ikarashiMDC.h"

/*サンプルコード


#include "mbed.h"
#include "SEKIkikou.h"

Serial serial(PC_10, PC_11, 115200);

ikarashiMDC motor[] = {
    ikarashiMDC(0,0,SM,&serial),
    ikarashiMDC(0,1,SM,&serial),
    ikarashiMDC(0,2,SM,&serial),
};

int main(){
    uint8_t b[4];
    int env[3];
    SEKIkikou seki(&motor[0], &motor[1], &motor[2], &b[0], &b[1], &b[2], &b[3], &env[0], &env[1], &env[2]);
    
    for(int i=0; i<4; i++){
        b[i] = 0;
        if(i < 3) env[i] = 0;   
    }
    
    while(1){
        seki.runLift(0.1);   
    }
}

*/

class SEKIkikou
{
public:

    SEKIkikou(ikarashiMDC *ik1, ikarashiMDC *ik2, ikarashiMDC *ik3, uint8_t *b1, uint8_t *b2, uint8_t *b3, uint8_t *b4, int *env1, int *env2, int *env3);
    
    void init(ikarashiMDC *ik1, ikarashiMDC *ik2, ikarashiMDC *ik3, uint8_t *b1, uint8_t *b2, uint8_t *b3, uint8_t *b4, int *env1, int *env2, int *env3);
    
    void runAll(float speedI, float speedLoad, float speedLift, int angle);
    
    void runInjection(float speed);
    
    void runLoad(float speed);
    
    void runLift(float speed, int angle);
    
    void stopAll();

private:
    Timer timer;
    uint8_t *button[4];
    int *encoder[3];
    int encoderAngle[3];
    int liftFlag;
    int envBuff;
    int buff[2];
    float mspeed[3];
    bool injecterFlag;
    ikarashiMDC *ik[3];
};

#endif