#ifndef POSITION_CONTROLLER_H
#define POSITION_CONTROLLER_H

#include "mbed.h"
const float F_PI = 3.141593f;

class PositionController {
    public :
        PositionController(float accDistance_, float decDistance_, float initialVelocity_, float terminalVelocity_, float maxVelocity_);

        void compute(int positionX, int positionY);
        void targetXY(int targetX_, int targetY_);
        float getVelocityX();
        float getVelocityY();
    private :

        float generateSineWave(float x, float initV, float termV, float start, float length);

        float accDistance;
        float decDistance;
        float accTrue;
        float decTrue;
        float initialVelocity;
        float terminalVelocity;
        float maxVelocity;
        float target;
        int targetX;
        int targetY;
        float radians;
        float velocity[2];

        bool enoughDistance;

        float getVelocity(int position);
};
#endif

