#ifndef R1370_H
#define R1370_H

#include "mbed.h"
#include <vector>

#define R1370_BUFFER_SIZE 15
#define R1370_HEADER0 0xAA
#define R1370_HEADER1 0x00

class R1370 : public RawSerial
{
public :
    R1370(PinName tx, PinName rx);

    float getAngle();
    float getRelativeAngle();
    float getRate();
    float getRadian();
    float getRelativeRadian();
    int16_t getAcc(char l);
    int16_t getAcc(int i);
    int16_t getAccX();
    int16_t getAccY();
    int16_t getAccZ();
    void reset();
    
    unsigned char upbit();
    unsigned char downbit();
    
    
private :
    void receiveByte();
    void checkData();
    void assembleLoop();
    void assemble();
    
    uint8_t index;
    int16_t angle;
    int16_t rate;
    int16_t acc[3];
    uint8_t reserved;
    uint8_t buffer[R1370_BUFFER_SIZE];
    uint8_t data[R1370_BUFFER_SIZE-3];
    uint8_t bufferPoint;
    uint8_t receivedBytes;
    int16_t zeroPoint;
    float relativeAngle;
    
    unsigned char upbit_, downbit_;
};

#endif