#ifndef PS3_H
#define PS3_H

#include "mbed.h"

#define PS3_TIMEOUT_COUNT 10
#define PS3_BUFFER_SIZE 20
#define PS3_HEADER0 'R'
#define PS3_HEADER1 'B'
#define PS3_HEADER2 'N'

#define LEFT_X 0
#define LEFT_Y 1
#define RIGHT_X 2
#define RIGHT_Y 3
#define L2 0
#define R2 1
#define UP 0
#define DOWN 1
#define LEFT 2
#define RIGHT 3
#define TRIANGLE 6
#define CROSS 7
#define SQUARE 8
#define CIRCLE 9
#define L1 4
#define R1 5
#define L3 10
#define R3 11
// #define PS 12
// #define SELECT 13
// #define START 14

class PS3 : public RawSerial
{
public :
    PS3(PinName tx, PinName rx);

    bool getButton(int n);
    uint8_t getStick(int n);
    uint8_t getTrigger(int n);
    bool status;
    
private :
    void receiveByte();
    void assemble();
    void checkData();
    void timeoutLoop();

    uint8_t *buffer;
    uint8_t bufferPoint;
    uint8_t receivedBytes;
    
    Ticker timeoutTicker;
    int timeout;

    bool button[12];
    uint8_t stick[4];
    uint8_t trigger[2];
};

#endif