#include "PS3.h"

PS3::PS3(PinName tx, PinName rx) :
    RawSerial(tx, rx, 115200),
    timeout(PS3_TIMEOUT_COUNT),
    status(false)
{
    bufferPoint = 0;
    receivedBytes = 0;
    buffer = new uint8_t[PS3_BUFFER_SIZE];
    attach(callback(this, &PS3::receiveByte));
    timeoutTicker.attach(callback(this, &PS3::timeoutLoop), 0.1);
}

void PS3::receiveByte()
{
    buffer[bufferPoint % PS3_BUFFER_SIZE] = getc();
    timeout = 0;
 
    if(bufferPoint != 0xff) {
        ++bufferPoint;
    } else {
        bufferPoint = (255%PS3_BUFFER_SIZE)+1;
    }
 
    ++receivedBytes;
 
    if(receivedBytes >= PS3_BUFFER_SIZE) checkData();
}

void PS3::assemble()
{
    uint8_t data, i;

    for(i = 0; i < 4; i++) {
        stick[i] = buffer[i+9];
    }
    for(i = 0; i < 2; i++) {
        trigger[i] = buffer[i+13];
    }
    data = buffer[15];
    for(i = 0; i < 6; i++) {
        button[i] = data & 0x01;
        data >>= 1;
    }
    data = buffer[16];
    for( ; i < 12; i++) {
        button[i] = data & 0x01;
        data >>= 1;
    }
}

void PS3::checkData()
{
    for(int i = 0; i < PS3_BUFFER_SIZE; i++) {
        if(buffer[i % PS3_BUFFER_SIZE] == PS3_HEADER0 && buffer[(i + 1) % PS3_BUFFER_SIZE] == PS3_HEADER1 && buffer[(i + 2) % PS3_BUFFER_SIZE] == PS3_HEADER2) {
            uint8_t checksum = 0x00;
            for(int j = 9; j < PS3_BUFFER_SIZE - 3; j++) {
                checksum += buffer[(i + j)% PS3_BUFFER_SIZE];
 
            }
            if(checksum == buffer[(i + PS3_BUFFER_SIZE - 3)% PS3_BUFFER_SIZE]) {
                assemble();
                receivedBytes = 0;
                
                return;
            }
        }
    }
}

void PS3::timeoutLoop()
{
    if(timeout >= PS3_TIMEOUT_COUNT) {
        status = false;
        return;
    }
    status = true;
    timeout++;   
}

bool PS3::getButton(int n)
{
    return button[n];
}

uint8_t PS3::getStick(int n)
{
    return stick[n];
}

uint8_t PS3::getTrigger(int n)
{
    return trigger[n];
}
