﻿#include "mbed.h"

#define PI 3.141592

DigitalOut leds[8] = { PA_11,LED1, PB_2, PB_1, PB_15, PB_14, PB_13, PC_4 };
I2C i2c(I2C_SDA, I2C_SCL);
Serial    FEP02(PC_6, PA_12);
Serial    pc(USBTX, USBRX);

const int  addr[4] = { 0x10, 0x23, 0x56, 0x76 };
int       i, dig, i2cVAL, error_val = 0;
// double    rad, prePwmDuty[4], PwmDuty[4];

int main()
{
    char     data[5] = { 0 }, FR_motor[2], RR_motor[2], RL_motor[2], FL_motor[2];
    int  i, dig, i2cVAL, error = 0;
    double rad, prePwmDuty[4], PwmDuty[4];
    i2c.frequency(300000);  // I2Cの通信速度設定
    FEP02.baud(19200);// シリアルのボーレートを19200に設定
    while(1) {                  // 受信
        if(FEP02.getc() == 255) {
            for(i = 0; i < 5; i++) {
                data[i]  = FEP02.getc();
                error_val = 0;
            }
            if(FEP02.getc() != 127) {
                error_val++;
            }
        }  else {
            error_val++;
        }
        if(error > 10) {    // 受信error
            dig = 360;
            pc.printf("error\r\n");
        }
        dig = data[0] + data[1] * 128;// 受信データから元の角度に変換
        rad = ((double) dig / 180.0) * PI;      // radに変換
        if(dig >= 360) {
            prePwmDuty[0] = 0;
            prePwmDuty[1] = 0;
            prePwmDuty[2] = 0;
            prePwmDuty[3] = 0;
            pc.printf("stop\r\n");
        } else {
            // 各モータへの出力を算出
            prePwmDuty[0] = sin(rad - (1.0 / 4.0) * PI);
            prePwmDuty[1] = sin(rad - (3.0 / 4.0) * PI);
            prePwmDuty[2] = sin(rad - (5.0 / 4.0) * PI);
            prePwmDuty[3] = sin(rad - (7.0 / 4.0) * PI);
        }
        FR_motor[0] = 127 + prePwmDuty[0] * 127;
        RR_motor[0] = 127 + prePwmDuty[1] * 127;
        RL_motor[0] = 127 + prePwmDuty[2] * 127;
        FL_motor[0] = 127 + prePwmDuty[3] * 127;
        i2cVAL    += i2c.write(addr[0], FR_motor, 2, false);
        i2cVAL    += i2c.write(addr[1], RR_motor, 2, false);
        i2cVAL    += i2c.write(addr[2], RL_motor, 2, false);
        i2cVAL    += i2c.write(addr[3], FL_motor, 2, false);
        if(i2cVAL) {
            leds[2] = 1;
        } else {
            leds[2] = 0;
        }
        pc.printf("%d,%d,%d,%d,%d\r\n", dig, FR_motor[0], data[2], data[3], data[4]);
    }
}
