#include "wheel_unit.h"

wheel_unit::wheel_unit() :
    sboard(PC_6, PC_7),
    ps3(PS3_TX,PS3_RX),
    pid(3.0,3.0,0.000005,0.01),
    pc(USBTX,USBRX),
    omni(4),
    serial(MDC_TX,MDC_RX,115200),
    serialcontrol(SC)
{
    sboard.baud(115200);
    sboard.setHeaders('H', 'Z');
    sboard.startReceive(6);
    
    pc.baud(1152000);
    pid.setInputLimits(-18000,18000);
    pid.setOutputLimits(-1.0,1.0);
    pid.setBias(0);
    pid.setMode(1);
    default_angle = ((rx_data[0] << 8) | rx_data[1]);
    if(rx_data[0] >= 128)
        default_angle = ((default_angle - 32768) * -1);
    motor = new ikarashiMDC*[4];
    motor[0] = new ikarashiMDC(&serialcontrol,0,0,SM,&serial);
    motor[1] = new ikarashiMDC(&serialcontrol,0,1,SM,&serial);
    motor[2] = new ikarashiMDC(&serialcontrol,0,2,SM,&serial);
    motor[3] = new ikarashiMDC(&serialcontrol,0,3,SM,&serial);
    omni.wheel[0].setRadian(PI / 4.0 * 1.0 );
    omni.wheel[1].setRadian(PI / 4.0 * 7.0 );
    omni.wheel[2].setRadian(PI / 4.0 * 5.0 );
    omni.wheel[3].setRadian(PI / 4.0 * 3.0 );
}

void wheel_unit::main_do()
{
    for(int i = 0; i < 6; i++)pc.printf("%3d. ",rx_data[i]);
        pc.printf("\r\n");
        sboard.getData(rx_data);
    int angle = ((rx_data[0] << 8) | rx_data[1]);
    encoder1 = ((rx_data[2] << 8) | rx_data[3])- 32768;
    encoder2 = ((rx_data[4] << 8) | rx_data[5])- 32768;

    if(rx_data[0] >= 128)
        angle = ((angle - 32768) * -1);
    angle = -1*(angle - default_angle);
    //if(rx_data[0] >= 128)
//        yawdegree = ((yawdegree - 32768) * -1);
//    yawdegree = -1*(yawdegree - default_angle);
//    if((yawdegree - beforeYaw) > 350)yawMode--;
//    else if((yawdegree - beforeYaw) < -350)yawMode++;
//    beforeYaw = yawdegree;
//    angle = 360*yawMode + yawdegree;
//    pc.printf("sb*%d/%d/%d/",angle,rx_data[0],rx_data[1]);
    pid.setSetPoint(0.0);
    pid.setProcessValue(double(angle));
    double pid_power = pid.compute();
//    pc.printf("sp1*%f",pid_power);
    for(i = 0; i < 12; i++) {
        b[i] = ps3.getButton(i);
//        pc.printf("%d/",b[i]);
    }
    for(i = 0; i < 4; i++) {
        stick[i] = ps3.getStick(i);
//        pc.printf("%d/",stick[i]);
    }
    double X = (double)(stick[0]/255.0 - 0.5);
    double Y = (double)(stick[1]/255.0 - 0.5);
    double spin_stick = (double)(stick[2]/255.0 - 0.5) / 5.0;
//    pc.printf("sps*%.3f",spin_stick);
    if(spin_stick >= 0.03 || spin_stick <= -0.03) {
        default_angle = ((rx_data[0] << 8) | rx_data[1]);
        if(rx_data[0] >= 128)
            default_angle = ((default_angle - 32768) * -1);
        pid.reset();
    }
    if(b[0])Y=-0.3;
    if(b[1])Y=0.3;
    if(b[2])X=-0.3;
    if(b[3])X=0.3;
    if(X <=0.1&&X>=-0.1)X = 0.0;
    if(Y <=0.1&&Y>=-0.1)Y = 0.0;
    if(b[5] == 1) {
        X = 2*X;
        Y = 2*Y;
    }
    if((stick[0] + stick[1] + stick[2] + stick[3]) == 0){
      X = 0;
      Y = 0;
      pid_power = 0;
      spin_stick = 0;
    }
    omni.computeXY(-Y,X,pid_power - spin_stick);
    for(int i = 0; i < 4; i++) {
        motor[i]->setSpeed(omni.wheel[i]);
//        pc.printf("%f//",(double)omni.wheel[i]);
    }
//    pc.printf("%.3f/%.3f",X,Y);
    pc.printf("/%d/%d",encoder1,encoder2);

//    pc.printf("\n\r");
}

int wheel_unit::encoder1Get()
{
    return encoder1;
}
int wheel_unit::encoder2Get()
{
    return encoder2;
}

int wheel_unit::getbutton(int buttonNumber)
{
    return !b[buttonNumber];
}
