
#include "mbed.h"
#include "ikarashiSV.h"
#include "Servo.h"

DigitalOut led1(LED1);
Serial pc(USBTX, USBRX,115200);

ikarashiSV slv(PC_7,PB_10,PB_4,PB_5);
Servo servo(PB_14);

//ボタンを押したときor離したときを読み取る定義の仕方
InterruptIn button(USER_BUTTON);

void add()
{
    slv.add_state();
}

int main()
{
    int val;
    servo.calibrate(0.00095, 90);
    servo.write(0);
    while(1) {
        button.fall(&add);
        val = slv.state_show();
        pc.printf("\t\tstate : %d",val);
        if(val%3 == 2){
            servo.write(0.3);
        }else{
            servo.write(0);
        }
        if(val >= 1) {
            slv.solenoid(val%3);
        }
        slv.solenoid_show();
    }
}