#include "ikarashiSV.h"

ikarashiSV::ikarashiSV(PinName pin_a,PinName pin_b,PinName pin_c,PinName pin_d):
    port_a(pin_a), port_b(pin_b), port_c(pin_c), port_d(pin_d)
{
    state = 0;
    solenoid_status = 0;
}

void ikarashiSV::add_state()
{
    state++;
}

void ikarashiSV::solenoid(int _state)
{
    switch(_state) {
        case 1:
            //投げる
            port_a = 0;
            port_b = 1;
            port_c = 0;
            port_d = 1;
            solenoid_status = 1;
            break;
        case 2:
            //戻る
            port_c = 1;
            port_d = 0;
            port_a = 1;
            port_b = 0;
            solenoid_status = 2;
            break;
        case 0://禅開放
            port_c = 0;
            port_d = 1;
            solenoid_status = 0;
            break;
    }
}

void ikarashiSV::solenoid_show()
{
    switch(solenoid_status) {
        case 1:
            printf("1:push\t");
            break;
        case 2:
            printf("1:pull\t");
            break;
        case 0:
            printf("1:open\t");
            break;
    }
}

int ikarashiSV::state_show()
{
    return state;
}


ikarashiSV2::ikarashiSV2(PinName pin_e, PinName pin_f):
    port_e(pin_e),port_f(pin_f)
{
    solenoid_status2 = 0;
}

void ikarashiSV2::solenoid(int _state2)
{
    switch(_state2) {
        case 1://push
            port_e = 0;
            port_f = 1;
            solenoid_status2 = 1;
            break;
        case 0://pull
            port_e = 1;
            port_f = 0;
            solenoid_status2 = 0;
            break;
    }
}

void ikarashiSV2::solenoid_show()
{
    if(solenoid_status2) {
        printf("2:push\t");
    } else {
        printf("2:pull\t");
    }
}

/* サンプルコード

#include "mbed.h"
#include "ikarashiSV.h"

DigitalOut led1(LED1);
Serial pc(USBTX, USBRX,115200);

ikarashiSV slv1(PB_5,PB_4,PB_10,PA_5);
ikarashiSV2 slv2(PB_9,PB_8);
Servo servo(PB_14);
Ticker timer;

//ボタンを押したときor離したときを読み取る定義の仕方
InterruptIn button(USER_BUTTON);

int check = 0;

void add()
{
    if(check >= 1) {
        slv1.add_state();
    }
    check++;
}

int main()
{
    int val;
    timer.attach(&add, 2);
    while(1) {
        val = slv1.state_show();
        pc.printf("state : %d",val);
        pc.printf("\tservo : %0.2f\t",servo.read());
        slv1.solenoid_show();
        slv2.solenoid_show();
        printf("\n\r");
        slv1.solenoid(val%3);
        slv2.solenoid(val%2);
    }
}

*/