#ifndef FEP_H
#define FEP_H

#include "mbed.h"

#define FEP_BUFFER_SIZE 22
#define FEP_HEADER0 'R'
#define FEP_HEADER1 'B'
#define FEP_HEADER2 'N'

class FEP : public RawSerial
{
public :
    FEP(PinName tx, PinName rx, uint8_t addr, int baud=115200);

    void startReceive(uint16_t dataSize);
    void getData(uint8_t data_[]);
    void sendData(uint8_t *data_[], uint8_t length);

private :
    void receiveByte();
    void checkData();

    uint8_t *buffer;
    uint8_t bufferPoint;
    uint8_t receivedBytes;

    uint16_t bufferSize;
    uint8_t* data;

    uint8_t _address;
};

#endif