#include "mbed.h"
#include "FEP.h"
#include "pin_config.h"

AnalogIn finger[]={
        AnalogIn(A_IN_7),
        AnalogIn(A_IN_6),
        AnalogIn(A_IN_5),
        AnalogIn(A_IN_3),
        AnalogIn(A_IN_2)
};
//8,1
//5

FEP fep(PC_12,PD_2,003);

Serial pc(USBTX,USBRX,115200);
//Serial serial(PC_10,PC_11,9600);

DigitalIn b(USER_BUTTON);

int main()
{
  
    float open_val[5],close_val[5],now_val[5],bending_condition[5];
    uint8_t data[5];
    
    for(int i=0;i<5;i++)close_val[i] = finger[i];

    while(1) {
        bool b_ = b;
        if(!b_){
            for(int i=0;i<5;i++)open_val[i] = finger[i];
        
            while(1){  
  
                for(int i = 0;i<5;i++){
                    now_val[i] = finger[i];
                    bending_condition[i] = (now_val[i] - close_val[i]) / (open_val[i] - close_val[i]) * 100;
                    if(open_val[i] <= now_val[i]) bending_condition[i] = 100.0;
                    if(close_val[i] >= now_val[i]) bending_condition[i] = 0.0;
                    data[i] = (uint8_t)((1-bending_condition[i] / 100 )* 255);
                    //pc.printf("finger%d:%3d%",i+1,data[i]);
                    //pc.printf(",close:%.2f,open:%.2f,now:%.2f",close_val[i],open_val[i],now_val[i]);
                }
                
                
                /*
                pc.printf("---");
                if(bending_condition[0]+bending_condition[1]+bending_condition[2]+bending_condition[3]+bending_condition[4] <= 50.0)pc.printf("グー");
                if(bending_condition[0]+bending_condition[3]+bending_condition[4] <= 100.0 && bending_condition[1]+bending_condition[2] >= 150.0)pc.printf("チョキ");
                if(bending_condition[1]+bending_condition[2]+bending_condition[3]+bending_condition[4] <= 50.0 &&+bending_condition[0] >= 80.0)pc.printf("good");
                if(bending_condition[0]+bending_condition[1]+bending_condition[2]+bending_condition[3]+bending_condition[4] >= 400.0)pc.printf("パー");
                pc.printf("---");
                */
                //pc.printf("\n\r");
                
                
                
                
                pc.printf("%3d,%3d,%3d,%3d,%3d\n\r",data[0],data[1],data[2],data[3],data[4]);
                //for(int j = 0;j<=5;j++)serial.putc(data[j]);
                fep.sendData(data,5);

            }
        }
    }
}
