#ifndef MEASURING_WHEEL_H
#define MEASURING_WHEEL_H

#include "mbed.h"
#include "QEI.h"
#include "R1370.h"
#include "Dense.h"

#define FIRST_HEDDER 0xEE
#define SECOND_HEDDER 0xFF
#define PPR 500.0
#define PIII 3.14159265358979

class MeasuringWheel
{
public :
    MeasuringWheel(PinName channel1_1, PinName channel1_2, PinName channel2_1, PinName channel2_2, PinName channel3_1, PinName channel3_2,PinName R1370TX,PinName R1370RX);

    double getOutX();
    double getOutY();
    double getWheel1(),getWheel2(),getWheel3();
    double getjyroAngle();
    double yaw;
private :
    double diameter[3];
    double distance[3];
    double radian[3];
    Eigen::Matrix3d coefficient;
    Eigen::Vector3d wheel;
    Eigen::FullPivHouseholderQR<Eigen::Matrix3d> dec;
    Eigen::Vector3d ans;
    double miniX,miniY,X,Y,subX,subY,minusX,minusY;
    int loopCounter;
    void computeXY();
    void threadloop();

    QEI w1;
    QEI w2;
    QEI w3;
    R1370 r1370;
    double Cdif, yawdegree;
    Thread thread;
    uint16_t X_, Y_,ofsetX, ofsetY, yawdegree_;
    void resetposition();
};

#endif
