#include "bot.h"

Bot::Bot() :
    pad(XBee1TX, XBee1RX, ADDR1),
    RS485(MDTX, MDRX, 115200),
    RS485Controller(PWM1),
    powerSwitch(MDstop),
    quadOmni(&RS485Controller, &RS485),
    plane(),
    axis(),
    receiveSuccessed(0),
    frontDegree(0),
    led(LED1),
    debugSerial(USBTX, USBRX, 115200)
{
    debugSerial.printf("OK\r\n");

    quadOmni.moveXY(0, 0, 0);
    powerSwitch = true;
}

void Bot::confirmPad()
{
    receiveSuccessed = pad.receiveState();
    if(!pad.getButton2(0) && !pad.getButton2(1)) {
        powerSwitch = 0;
    }
    if(!pad.getButton2(2) && !pad.getButton2(3)) {
        powerSwitch = 1;
    }
    if(!receiveSuccessed) {
        quadOmni.moveXY(0, 0, 0);
    }
}

void Bot::controllDrive()
{
    if(receiveSuccessed) {
        float moment = 0;
        //debugSerial.printf("%d\n\r", plane.getRawDegree());
        /*if(pad.getNorm(0) > 0.5) {
            plane.setPoint((pad.getRadian(0) - M_PI / 2) * (180.0 / M_PI));
            plane.confirm();
        }*/
        plane.confirm();
        if(pad.getStick(0)) {
          moment = -pad.getStick(0) / 2.0;
          plane.resetOffset();
        } else {
          moment = -plane.getCalculationResult();
        }
        debugSerial.printf("%f\r\n",moment);
        quadOmni.moveXY(
                pad.getStick(2),
                -pad.getStick(3),
                0,
                0,
                moment
                );
    } else {
        quadOmni.moveXY(0, 0, 0);
    }
}

void Bot::controllDrive2()
{
  plane.confirm();
  axis.confirm();
  float moment = 0;
  float norm = 0;
  static float beforestick = pad.getStick(0);

  if(!pad.getButton2(5)) {
      axis.resetOffset();
      //debugSerial.printf("Force RESeT\n\r");
  }

  if((beforestick >= 0.2 && pad.getStick(0) < 0.2) || (beforestick <= -0.2 && pad.getStick(0) > -0.2)) {
      plane.setPoint(0.0);
      plane.resetOffset();
  }
  /*if(!pad.getButton2(1)&&pad.getButton2(3)) {
        plane.setPoint((M_PI / 4)*(180.0 / M_PI));
      } else if(pad.getButton2(1)&&!pad.getButton2(3)){
        plane.setPoint(-(M_PI / 4)*(180.0 / M_PI));
      } else {
        plane.setPoint(0.0);
  }*/
  if(pad.getStick(0) > 0.2 || pad.getStick(0) < -0.2) {
      moment = pad.getStick(0);
  } else  {
      moment = plane.getCalculationResult();

  }
  // if(pad.getButton1(0)) {
      norm = pad.getNorm(1);
  // } else {
  //     norm = pad.getNorm(1) / 2.0;
  // }
  if(receiveSuccessed) {
      quadOmni.moveCircular(
              norm,
              pad.getRadian(1) - axis.getCurrentDegree() /1.0 * (M_PI / 180.0) + M_PI,
              0.0,
              0.0,
              -moment
              );
  } else {
      quadOmni.moveXY(0, 0, 0);
  }
  beforestick = pad.getStick(0);
}

void Bot::controllDrive3()
{
    static int rollR = 0;
    static int rollL = 0;
    static int mode = 1;
    if(receiveSuccessed) {
        if(rollR && !pad.getButton2(2)) {
            frontDegree += ADJUST_DEGREE;
        }
        rollR = pad.getButton2(2);

        if(rollL && !pad.getButton2(0)) {
            frontDegree -= ADJUST_DEGREE;
        }
        rollL = pad.getButton2(0);

        if(!pad.getButton2(4)) {
            mode = 1;
        }

        if(!pad.getButton2(5)) {
            mode = 2;
        }

        if(mode == 1) {
            plane.setPoint(frontDegree);
            plane.confirm();

            quadOmni.moveXY(
                    pad.getStick(0),
                    -pad.getStick(1),
                    0.5,
                    0.5,
                    -plane.getCalculationResult()
                    );
        }
        if(mode == 2) {
            plane.setPoint(90.0 + frontDegree);
            plane.confirm();

            quadOmni.moveXY(
                    -pad.getStick(1),
                    -pad.getStick(0),
                    0.5,
                    0.5,
                    -plane.getCalculationResult()
                    );
        }
    } else {
        quadOmni.moveXY(0, 0, 0);
    }
}

void Bot::controllDrive4()
{
    if(receiveSuccessed) {
        quadOmni.moveXY(
                pad.getStick(2),
                -pad.getStick(3),
                0.0,
                0.0,
                -pad.getStick(0)
                );
    } else {
        quadOmni.moveXY(0, 0, 0);
    }
}

void Bot::controllDrive5()
{
  plane.confirm();
  axis.confirm();
  float moment = 0;
  float norm = 0;
  static float beforestick = pad.getStick(0);
  static int mode = 0;

  led = mode;
  if(!pad.getButton2(5)) {
      axis.resetOffset();
  }

  if((beforestick >= 0.2 && pad.getStick(0) < 0.2) || (beforestick <= -0.2 && pad.getStick(0) > -0.2)) {
      plane.setPoint(0.0);
      plane.resetOffset();
  }
  if(pad.getStick(0) > 0.2 || pad.getStick(0) < -0.2) {
      moment = pad.getStick(0);
  } else  {
      moment = plane.getCalculationResult();
  }
  norm = pad.getNorm(1);

  if(receiveSuccessed) {
    if(!pad.getButton2(0) && !pad.getButton2(1)) {
        mode = 0;
    }
    if(!pad.getButton2(2) && !pad.getButton2(3)) {
        mode = 1;
    }
    if(mode){
      quadOmni.moveCircular(
              norm,
              pad.getRadian(1) - axis.getCurrentDegree() /1.0 * (M_PI / 180.0) + M_PI,
              0.0,
              0.0,
              -moment
              );
    } else {
      quadOmni.moveXY(
              pad.getStick(2),
              -pad.getStick(3),
              0.0,
              0.0,
              -pad.getStick(0)
              );
    }
  } else {
      quadOmni.moveXY(0, 0, 0);
  }
  beforestick = pad.getStick(0);
}


void Bot::calibrate()
{
}

void Bot::checkConnection()
{
  if(receiveSuccessed == 1) debugSerial.printf("ON \r\n");
  else  debugSerial.printf("OFF \r\n");
}

void Bot::checkDegree()
{
    debugSerial.printf("%f %f\r\n",plane.getRawDegree(), plane.getCalculationResult());
}


void Bot::checkReceiveData()
{
  debugSerial.printf("%f %f %f %f\r\n",pad.getStick(0),pad.getStick(1),pad.getStick(2),pad.getStick(3));
}
