/**
* @file bot.h
* @brief ロボットのクラス
*/
#ifndef BOT_H
#define BOT_H

#include "mbed.h"
#include "math.h"
#include "pin_config.h"
#include "controller.h"
#include "PID_controller.h"
#include "wheel_unit.h"
#include "def.h"

const float ADJUST_DEGREE = 5.0;
/**
* @brief ロボットのクラス
*/
class Bot
{
public :
    /**
    * @brief コンストラクタ
    */
    Bot();

    /**
    * @brief センサなどの値を更新
    */
    void confirmPad();

    /**
    * @brief 足回りの制御
    */
    void controllDrive();
    void controllDrive2();
    void controllDrive3();
    void controllDrive4();
    void controllDrive5();

    /**
    * @brief 機構部の制御
    */
    void controllMech();

    /**
     * センサのキャリブレーション
     */
    void calibrate();

    void checkConnection();

    void checkDegree();

    void checkReceiveData();

private :
    Controller pad;
    Serial RS485;
    DigitalOut RS485Controller;
    DigitalOut powerSwitch;
    WheelUnit quadOmni;
    PIDC plane;
    PIDC axis;
    int receiveSuccessed;
    float frontDegree;
    Serial debugSerial;
    Timer t;
    DigitalOut led;
};

#endif//BOT_H
