#include "tentacle_unit.h"

Tentacle::Tentacle(DigitalOut* RS485Controller, Serial* RS485) :
	tentacleMotor({
    {RS485Controller, 0, 3, SM, RS485},
    {RS485Controller, 0, 0, SM, RS485},
  }),
	// right(LIMIT1,LIMIT0),
  // left(LIMIT3,LIMIT4)
	front({{LIMIT1},{LIMIT3}}),
	back({{LIMIT0},{LIMIT4}})
{
	tentacleMotor[0].braking = true;
  tentacleMotor[1].braking = true;
}

void Tentacle::rightMove(float speed)
{
	if(speed*front[0]>0) speed=0;
  if(speed*back[0]<0) speed=0;
  // if(speed*right.getPosition() < 0)    speed = 0;
  // if(speed*right.getPosition() > 0)    right.resetPosition();
	tentacleMotor[0].setSpeed(speed);
}

void Tentacle::leftMove(float speed)
{
	if(speed*front[1]>0) speed=0;
  if(speed*back[1]<0) speed=0;
  // if(speed*left.getPosition() < 0)    speed = 0;
  // if(speed*left.getPosition() > 0)    left.resetPosition();
  tentacleMotor[1].setSpeed(speed);
}

void Tentacle::stop()
{
  tentacleMotor[0].setSpeed(0);
  tentacleMotor[1].setSpeed(0);
}
