/**
* @file bot.h
* @brief ロボットのクラス
*/
#ifndef BOT_H
#define BOT_H

#include "mbed.h"
#include "pin_config.h"
#include "controller.h"
#include "tentacle_unit.h"
#include "elevator.h"
#include "sword_unit.h"
#include "def.h"

/**
* @brief ロボットのクラス
*/
class Bot
{
public :
    /**
    * @brief コンストラクタ
    */
    Bot();

    /**
    * @brief センサなどの値を更新
    */
    void confirmPad();

    /**
    * @brief 機構部の制御
    */
    void controllMech();

    void checkConnection();

    void checkReceiveData();

private :
    Controller pad;
    Serial RS485;
    DigitalOut RS485Controller;
    DigitalOut powerSwitch;
    Tentacle tentacle;
    Elevator nishijoSword;
    Sword nishijo;
    bool receiveSuccessed;
};

#endif//BOT_H
