#include "bot.h"

Bot::Bot() :
    pad(FEPTX, FEPRX, ADDR2),
    RS485(MDTX, MDRX, 115200),
    RS485Controller(NC),
    powerSwitch(MDstop),
    tentacle(&RS485Controller, &RS485),
    nishijoSword(&RS485Controller, &RS485),
    nishijo(&RS485Controller, &RS485),
    receiveSuccessed(0)
{
    tentacle.stop();
    nishijoSword.stop();
    nishijo.stop();
    powerSwitch = true;
}

void Bot::confirmPad()
{
    receiveSuccessed = pad.receiveState();
    // if(!pad.getButton2(3) && !pad.getButton2(0)) {
    //     powerSwitch = 0;
    // }
    if(!receiveSuccessed) {
        tentacle.stop();
        nishijoSword.stop();
        nishijo.stop();
    }
}

void Bot::controllMech()
{
  if(receiveSuccessed) {

      //if(!pad.getButton1(2)&&!pad.getButton1(4)) powerSwitch=0;
    tentacle.leftMove(pad.getStick(3));
    tentacle.rightMove(pad.getStick(1));

    if (!pad.getButton2(0)) nishijoSword.move(-WIND_UP_SPEED);
    if (!pad.getButton2(1)) nishijoSword.move(WIND_UP_SPEED);
    if(pad.getButton2(0) && pad.getButton2(1))  nishijoSword.move(0);

    if (!pad.getButton2(2)) nishijo.move(-SWORD_SPEED);
    if (!pad.getButton2(3)) nishijo.move(SWORD_SPEED);
    if(pad.getButton2(2) && pad.getButton2(3))  nishijo.move(0);
  } else {
    tentacle.stop();
    nishijoSword.stop();
    nishijo.stop();
  }
}
