/**
* @file bot.h
* @brief ロボットのクラス
*/
#ifndef BOT_H
#define BOT_H

#include "mbed.h"
#include "math.h"
#include "pin_config.h"
#include "controller.h"
#include "PID_controller.h"
#include "tentacle_unit.h"
#include "elevator.h"
#include "sword_unit.h"
#include "wheel_unit.h"
#include "def.h"

const float ADJUST_DEGREE = 5.0;
/**
* @brief ロボットのクラス
*/
class Bot
{
public :
    /**
    * @brief コンストラクタ
    */
    Bot();

    /**
    * @brief センサなどの値を更新
    */
    void confirmPad1();
    void confirmPad2();

    /**
    * @brief 足回りの制御
    */
    void controllDrive();
    void controllDrive2();
    void controllDrive3();
    void controllDrive4();

    /**
    * @brief 機構部の制御
    */
    void controllMech();

    /**
     * センサのキャリブレーション
     */
    void calibrate();

    void checkConnection();

    void checkDegree();

    void checkPacket();

    void checkReceiveData();

private :
    Controller pad1;
    Controller pad2;
    Serial RS485;
    DigitalOut RS485Controller;
    DigitalOut powerSwitch;
    WheelUnit quadOmni;
    Tentacle tentacle;
    Elevator nishijoSword;
    Sword nishijo;
    PIDC plane;
    PIDC axis;
    int receiveSuccessed1;
    int receiveSuccessed2;
    float frontDegree;
    Serial debugSerial;
    Timer t;
};

#endif//BOT_H
