#ifndef WHEEL_UNIT_H
#define WHEEL_UNIT_H

#include "mbed.h"
#include "pin_config.h"
#include "omni_wheel.h"
#include "ikarashiMDC.h"

const int RS485_BAUD = 38400;

class WheelUnit {
public:
	WheelUnit(DigitalOut* RS485Controller, Serial* RS485);
	void moveXY(float X, float Y, float moment);
	void moveXY(float X, float Y, float gX, float gY, float moment);
	void moveCircular(float r, float radian, float moment);
	void moveCircular(float r, float radian, float gX, float gY, float moment);

private:
	OmniWheel omni;
	ikarashiMDC wheels[4];
protected:
};

#endif
