#include "tentacle_unit.h"

Tentacle::Tentacle(DigitalOut* RS485Controller, Serial* RS485) :
	tentacleMotor({
    {RS485Controller, 1, 3, SM, RS485},
    {RS485Controller, 1, 1, SM, RS485},
  }),
  right(PWM3, PWM6),left(PWM8,PWM10),
	debugSerial(USBTX, USBRX, 115200)
{
	tentacleMotor[0].braking = true;
  tentacleMotor[1].braking = true;
}

void Tentacle::rightMove(float speed)
{
  if(speed*right.getPosition() < 0)    speed = 0;
  if(speed*right.getPosition() > 0)    right.resetPosition();
	tentacleMotor[0].setSpeed(speed);
}

void Tentacle::leftMove(float speed)
{
  if(speed*left.getPosition() < 0)    speed = 0;
  if(speed*left.getPosition() > 0)    left.resetPosition();
  tentacleMotor[1].setSpeed(speed);
}

void Tentacle::stop()
{
  tentacleMotor[0].setSpeed(0);
  tentacleMotor[1].setSpeed(0);
}

void Tentacle::debugPrint()
{
	debugSerial.printf("right:%d left:%d\r\n",right.getPosition(),left.getPosition());
}
