/**
* @file bot.h
* @brief ロボットのクラス
*/
#ifndef BOT_H
#define BOT_H

#include "mbed.h"
#include "pin_config.h"
#include "controller.h"
#include "PID_controller.h"
#include "tentacle_unit.h"
#include "wheel_unit.h"
#include "sword_unit.h"
#include "elevator.h"
#include "def.h"

const float ADJUST_DEGREE = 5.0;

/**
* @brief ロボットのクラス
*/
class Bot
{
public :
    /**
    * @brief コンストラクタ
    */
    Bot();

    /**
    * @brief センサなどの値を更新
    */
    void confirmPad1();
    void confirmPad2();

    /**
    * @brief 足回りの制御
    */
    void drive();
    void controllDrive();
    void controllDrive2();
    void controllDrive3();

    /**
    * @brief 機構部の制御
    */
    void controllMech();

    /**
     * センサのキャリブレーション
     */
    void calibrate();

    void checkConnection();

    void debugCompass();

private :
    Controller pad1;
    Controller pad2;
    Serial RS485;
    DigitalOut RS485Controller;
    DigitalOut powerSwitch;
    WheelUnit quadOmni;
    Tentacle tentacle;
    Sword nishijo;
    Elevator nishijoSword;
    PIDC plane;
    PIDC axis;
    bool receiveSuccessed1;
    bool receiveSuccessed2;
    float frontDegree;
    DigitalOut led[3];
    Serial debugSerial;
    Timer t;
};

#endif//BOT_H
