#include "elevator.h"

Elevator::Elevator(DigitalOut* RS485Controller, Serial* RS485) :
  elevatorMotor(RS485Controller, 1, 2, SM, RS485),
  limit(PWM2, PWM1),
  debugSerial(USBTX, USBRX, 115200)
{
	elevatorMotor.braking = true;
}

void Elevator::move(float speed)
{
  if(speed*limit.getPosition() < 0)    speed = 0;
  if(speed*limit.getPosition() > 0)    limit.resetPosition();
	elevatorMotor.setSpeed(speed);
}

void Elevator::stop()
{
  elevatorMotor.setSpeed(0);
}

void Elevator::debugPrint()
{
  debugSerial.printf("elevator:%d\r\f",limit.getPosition());
}
