#include "mbed.h"
#include<motor.h>

//Serial    FEP02(PC_10, PC_11);
Serial    FEP02(PC_12, PD_2);
Serial    pc(USBTX, USBRX);
//InterruptIn limsw[2]= {PA_13,PA_14};
DigitalIn limsw[2]= {PA_13,PA_14};

/*
各モーターのセットアップ
right:右車輪  left:左車輪   reme:ロック  push:橋の押し出し    palink:平行リンク
*/
PwmOut right(PB_3);
PwmOut left(PA_10);
PwmOut reme(PC_9);
Motor push(PA_7,PA_6,PB_6);
//Motor palink(PA_12,PC_5,PA_5);

void stop()
{
    right=0.5;
    left=0.5;
    push.motor(0);
    //palink.motor(0);
    reme.pulsewidth_us(1575);
}


int main()
{
    FEP02.baud(19200);// シリアルのボーレートを19200に設定
    bool Button1[7]= {0},Button2[6]= {0},rock=0;
    char data[8]= {0};
    int  i,error=0;
    double pwm_r,pwm_l,x,y,r,l;
    /*while(n<2) {
        limsw[n].mode(PullUp);
        n++;
    }*/
    right.period_us(50);
    left.period_us(50);
    reme.period_ms(20);
    stop();
    while(1) {
        // 受信
        //FEP02.getc();
        if(FEP02.getc() == 255) {
            for(i = 0; i < 8; i++) {
                data[i]  = FEP02.getc();
            }
            data[4] -= 14;
            data[5] -= 14;
            for(i=0; i<7; i++) {
                Button1[i] = data[4] % 2;
                data[4] /= 2;
                //printf("%d,", Button1[i]);
            }
            for(i=0; i<6; i++) {
                Button2[i] = data[5] % 2;
                data[5] /= 2;
                //printf("%d,", Button2[i]);
            }
            //printf("%d,%d,%d,%d\n", data[0], data[1], data[2], data[3]);
            error = 0;

        }  else {
            error++;
            //pc.printf("*\n");
        }
        if((error <= 3)&&(data[0]!=255) ) {
            for(i=0; i<7; i++) {
                //pc.printf("%d,", Button1[i]);
            }
            for(i=0; i<6; i++) {
                //pc.printf("%d,", Button2[i]);
            }
            pc.printf("%d,%d,%d,%d,", data[0], data[1], data[2], data[3]);
            
            //足
            r=1.0;
            l=1.0;
            if(data[2]<122) {
                x=(data[2]-122)/122.0;
            } else if(data[2]>124) {
                x=(data[2]-124)/125.0;
            } else {
                x=0;
            }
            if(data[1]<122) {
                y=(data[1]-122)/122.0;
                l=0.983;
            } else if(data[1]>124) {
                y=(data[1]-124)/125.0;
                r=0.959;
            } else {
                y=0;
            }
            if(y==0) {
                pwm_r=x/2.0;
                pwm_l=x/2.0;
            } else {
                if(x>0) {
                    pwm_r=-y/1.2;
                    pwm_l=(y-y*fabs(x))/1.2;
                } else if(x<0) {
                    pwm_r=(-y+y*fabs(x))/1.2;
                    pwm_l=y/1.2;
                } else {
                    pwm_r=-y;
                    pwm_l=y;
                }
            }
            printf("    %f,%f\n",pwm_r,pwm_l);
            right=0.5+pwm_r*r/4.0;
            left=0.5+pwm_l*l/4.0;
            //押し出しラック
            if((Button2[2]==0)&&(Button2[3]==1)) {
                push.motor(1.0);
            } else if((Button2[2]==1)&&(Button2[3]==0)) {
                push.motor(-1.0);
            } else {
                push.motor(0);
            }
            
            //解除機構に関するもの
            //if(limsw[0])    rock=0;
            rock=0;
            if(!Button2[1])  rock=1;
            //if(!Button2[0])  rock=0;
            if(rock) {
                reme.pulsewidth_us(2400);
                pc.printf("open");
            } else {
                reme.pulsewidth_us(1575);
                pc.printf("rock");
            }
            
            //平行リンクだったもの
            /*if((Button1[3]==0)&&(Button1[5]==1)) {
                palink.motor(0.1);
            } else if((Button1[3]==1)&&(Button1[5]==0)) {
                palink.motor(-0.1);
            } else {
                palink.motor(0);
            }*/

        } else {   // 受信error
            pc.printf("*\n");
            stop();
        }
        //wait(0.01);
    }
}

