#ifndef MOTORSMLAP_H
#define MOTORSMLAP_H

#define SM 1
#define LAP 0

#include "mbed.h"
/**
* motorSmLap class
* class to drive A3921 with two different modes sm and lap
*/
class motorSmLap
{
public:
    /** creates motorSmLap instance
    *@param _dirH dirH pin
    *@param _dirL dirL pin
    *@param _pwm pwm pin
    */ 
    motorSmLap(PinName _dirH,PinName _dirL,PinName _pwm);
    /** set drive Mode won't work after setMotorSpeed() is called
    *@param _mode 0 for LAP 1 for SM
    */ 
    int setMode(int _mode);
    /** set Motor speed
    *@param speed  speed of motor ranging from -1 to 1
    */
    int setMotorSpeed(float speed);
    /** set pwm frequency
    *@param frequency needs to be bigger than 0
    */
    int setFreq(float freq);
    /** set this variable to 1 if you want to brake when the motorSpeed is set to 0
    */
    bool  braking;
private:
    int mode;
    bool started;
    DigitalOut dirH,dirL;
    PwmOut pwm;
};
#endif