#include "motorsmlap.h"
#include "mbed.h"

motorSmLap::motorSmLap(PinName _dirH,PinName _dirL,PinName _pwm):
    dirH(_dirH),dirL(_dirL), pwm(_pwm) {
    started = false;
    mode = SM;
    pwm.period(1/20000.0);
    dirL = 0;
    dirH = 0;
    pwm=0;
    braking=false;
}

int motorSmLap::setMode(int _mode)
{
        if(mode >1 || mode < 0 || started)
            return 1;
        mode = _mode;
        return 0;
}

int motorSmLap::setFreq(float freq)
{
        if(freq <= 0)
            return 1;
        pwm.period(1/freq);
        return 0;
}
        
int motorSmLap::setMotorSpeed(float speed)
{
    started = true;
    if(speed >=1.0)
        speed = 1.0;
    if(speed <= -1.0)
        speed = -1.0;
    if(mode == SM)
    {
        if(fabs(speed) > 0.02)
        {
            speed > 0 ? dirL = 1 : dirL = 0;
            dirH = 1;
            pwm = fabs(speed);
        }else{
            dirH = 0;
            dirL = 1;
            pwm = (float)(braking);
        }
    }else if(mode == LAP)
    {
        dirH = 1;
        dirL = 1;
        pwm = fabs((speed+1.0)/2.0);
    }else{
        return 1;
    }
    return 0;
}