/**
* @file bot.h
* @brief ロボットのクラス
*/
#ifndef BOT_H
#define BOT_H

#include "mbed.h"
#include "pin_config.h"
#include "controller.h"
#include "PID_controller.h"
#include "slider.h"
#include "wheel_unit.h"

const int ROLL = 0;
const int SWORD = 1;
const int DESTROY = 2;
const float ADJUST_DEGREE = 5.0;
/**
* @brief ロボットのクラス
*/
class Bot
{
public :
    /**
    * @brief コンストラクタ
    */
    Bot();

    /**
    * @brief センサなどの値を更新
    */
    void confirmAll();

    /**
    * @brief 足回りの制御
    */
    void controllDrive();
    void controllDrive2();
    void controllDrive3();
    void controllDrive4();

    /**
    * @brief 機構部の制御
    */
    void controllMech();

    /**
     * センサのキャリブレーション
     */
    void calibrate();

private :
    Controller pad;
    Serial RS485;
    DigitalOut RS485Controller;
    DigitalOut powerSwitch;
    WheelUnit quadOmni;
    Slider slider;
    ikarashiMDC armMotor[3];
    PIDC plane;
    PIDC axis;
    bool receiveSuccessed;
    float frontDegree;
    DigitalOut led[3];
    Serial debugSerial;
    int faceMode;
};

#endif//BOT_H
