#include "slider.h"

Slider::Slider(DigitalOut* RS485Controller, Serial* RS485) :
	slideMotor(RS485Controller, 1, 0, SM, RS485),
	downLimitSwitch(PWM3),
	upLimitSwitch(PWM2),
	slideSerial(USBTX, USBRX, 115200)
{
	slideMotor.braking = true;
}

void Slider::slide(float speed) {
    if(downLimitSwitch && speed > 0) speed = 0;
    if(upLimitSwitch && speed < 0) speed = 0;
    slideMotor.setSpeed(speed);
}
