/**
* @file arm_unit.h
* @brief アーム機構のStateクラス
*/
#ifndef ARM_UNIT_H
#define ARM_UNIT_H

#include "mbed.h"
#include "pin_config.h"

#include "QEI.h"

const int PULSES_PER_REV = 6;
// #define SLIDER_POINT

/**
* @brief アーム機構のStateクラス
*/
class Arm : public QEI {
public :

    /**
    * @brief コンストラクタ
    */
    Arm();

    /**
    * @bref スライダ高さリセット用のリミットスイッチの状態
    * @return limitSwitch
    */
    bool isPushed();

    /**
     * @brief 高さの値がリセットされたことがあるか
     * @return heightResetFlag(bool)
     */
    bool isResetted() const;

    /**
     * @brief 高さを取得
     * @return height
     */
    int getHeight();

private :
    void resetHeight();
    InterruptIn limitSwitch;

protected :
    bool heightResetFlag;

};

#endif//ARM_UNIT_H
