/**
* @file PID_controller.h
* @brief コンパスセンサを使ったPIDコントローラ
*
* Example :
* @code
* #include "mbed.h"
* #include "PID_controller.h"
*
* PIDC pidc;
*
* int main()
* {
*     while(1) {
*         pidc.confirm();
*         pc.printf("Hi, %f\r\n", pid.getCo());
*     }
* }
* @endcode
*/
#ifndef PID_CONTROLLER_H
#define PID_CONTROLLER_H

#include "mbed.h"
#include "pin_config.h"

#include "PID.h"
#include "HMC6352.h"

// const double M_PI = 3.141592653589793;
const double KC = 5.0;
const double TI = 0.0;
const double TD = 0.0;
const float INTERVAL  = 0.05;
const float INPUT_LIMIT = 180.0;
const float OUTPUT_LIMIT = 0.4;
const float BIAS = 0.0;

/**
* @brief コンパスセンサを使ったPIDコントローラ
*/
class PIDC : public PID, HMC6352, Ticker
{
public :
    /**
    * @brief defaultコンストラクタ,タイマ割り込みでの計算開始
    */
    PIDC();

    /**
     * @brief コンストラクタ
     * @param sda      sda HMC6352
     * @param scl      scl HMC6352
     * @param kc       KC
     * @param ti       TI
     * @param td       TD
     * @param interval interval
     */
    PIDC(PinName sda, PinName scl, float kc, float ti, float td, float interval);

    void confirm();
    float getCo() const;
    void calibration(int mode);
private :

    void updateOutput();

    int rawDegree;
    int offSetDegree;
    int turnOverNumber;
    int beforeDegree;

protected :
    float co;
    float processValue;
    int initDegree;
};

#endif//PID_CONTROLLER_H
