#include "PID_controller.h"

void PIDC::updateOutput()
{
    confirm();
}

PIDC::PIDC() :
    PID(KC, TI, TD, INTERVAL),
    HMC6352(HMCsda, HMCscl),
    rawDegree(0),
    offSetDegree(0),
    turnOverNumber(0),
    beforeDegree(0),
    co(0),
    processValue(0),
    initDegree(0)
{
    PID::setInputLimits(-INPUT_LIMIT, INPUT_LIMIT);
    PID::setOutputLimits(-OUTPUT_LIMIT, OUTPUT_LIMIT);
    PID::setBias(BIAS);
    PID::setMode(AUTO_MODE);
    PID::setSetPoint(0.0);

    HMC6352::setOpMode(HMC6352_CONTINUOUS, 1, 20);
    rawDegree = HMC6352::sample();
    beforeDegree = HMC6352::sample();
    offSetDegree = HMC6352::sample();
    initDegree = 0;
    turnOverNumber = 0;
//    this -> attach(this, &PIDC::updateOutput, INTERVAL);
}

PIDC::PIDC(PinName sda, PinName scl, float kc, float ti, float td, float interval) :
    PID(kc, ti, td, interval),
    HMC6352(sda, scl),
    rawDegree(0),
    offSetDegree(0),
    turnOverNumber(0),
    beforeDegree(0),
    co(0),
    processValue(0),
    initDegree(0)
{
    PID::setInputLimits(-INPUT_LIMIT, INPUT_LIMIT);
    PID::setOutputLimits(-OUTPUT_LIMIT, OUTPUT_LIMIT);
    PID::setBias(BIAS);
    PID::setMode(AUTO_MODE);
    PID::setSetPoint(0.0);

    HMC6352::setOpMode(HMC6352_CONTINUOUS, 1, 20);
    rawDegree = HMC6352::sample();
    beforeDegree = HMC6352::sample();
    offSetDegree = HMC6352::sample();
    initDegree = 0;
    turnOverNumber = 0;
//    this -> attach(this, &PIDC::updateOutput, INTERVAL);
}


void PIDC::confirm()
{
    rawDegree = HMC6352::sample();
    if(rawDegree - beforeDegree < -1800) turnOverNumber++;
    if(rawDegree - beforeDegree > 1800) turnOverNumber--;
    initDegree = rawDegree - offSetDegree + turnOverNumber * 3600;
    beforeDegree = HMC6352::sample();
    PID::setProcessValue(initDegree / 10.0);
    co = PID::compute();
}

float PIDC::getCo() const
{
    return co;
}


void PIDC::calibration(int mode)
{
    setCalibrationMode(mode);
}
