#include "arm_unit.h"

void Arm::resetHeight(void)
{
    QEI::reset();
    heightResetFlag = 1;
}

Arm::Arm() :
    QEI(Sensor4pin1a, Sensor4pin1b, NC, PULSES_PER_REV, X2_ENCODING),
    limitSwitch(Sensor3pin3a),
    heightResetFlag(0)
{
    QEI::reset();
    // limitSwitch.rise(this, &Arm::resetHeight);
    limitSwitch.rise(callback(this, &Arm::resetHeight));
}

bool Arm::isPushed()
{
    return limitSwitch.read();
}

bool Arm::isResetted() const
{
    return heightResetFlag;
}

int Arm::getHeight()
{
    return QEI::getCurrentState();
}
