/**
* @file bot.h
* @brief ロボットのクラス
*/
#ifndef BOT_H
#define BOT_H

#include "mbed.h"
#include "pin_config.h"
#include "motor_driver.h"
#include "controller.h"
#include "PID_controller.h"

#define ARM_MAX_SPEED 1
#define DESTROY_MAX_SPEED 1

/**
* @brief ロボットのクラス
*/
class Bot : public PIDC
{
public :
    /**
    * @brief コンストラクタ
    */
    Bot();

    /**
    * @brief センサなどの値を更新
    */
    void confirmAll();

    /**
    * @brief 足回りの制御
    */
    void controllDrive();

    /**
    * @brief 機構部の制御
    */
    void controllMech();
    
    void calibrate();

private :
    Controller pad;
    MotorDriver motor;
    bool suc;
};

#endif//BOT_H
