#include "IRsensor.h"

IRsensor::IRsensor(PinName pin):
    a_in(pin)
{
    thread_get_distance.start(callback(this, &IRsensor::threadloop_get_distance));
}

void IRsensor::threadloop_get_distance()
{
    while(true){
        compute_distance();
    }
}

void IRsensor::compute_distance(){
    getInputvoltage();
    originaldistance = changeVtoD(voltage);
}

void IRsensor::getInputvoltage(){
    voltage = a_in.read()*3.3f;
}

float IRsensor::changeVtoD(float voltage_)
{
    float distance_;
    
    if (voltage_ > 2.28f) {
        distance_ = 0.00f;
    } else if (voltage_ > 1.64f) {
        distance_ = -7.81f * voltage_ + 27.85f;
    } else if (voltage_ > 1.30f) {
        distance_ = -14.70f * voltage_ + 39.19f;
    } else if (voltage_ > 1.08f) {
        distance_ = -22.2f * voltage_ + 49.00f;
    } else if (voltage_ > 0.92f) {
        distance_ = -32.89f * voltage_ + 60.52f;
    } else if (voltage_ > 0.83f) {
        distance_ = -53.76f * voltage_ + 79.89f;
    } else if (voltage_ > 0.73f) {
        distance_ = -51.02f * voltage_ + 77.60f;
    } else if (voltage_ > 0.67f) {
        distance_ = -78.12f * voltage_ + 97.57f;
    } else if (voltage_ > 0.60f) {
        distance_ = -76.92f * voltage_ + 96.76f;
    } else if (voltage_ > 0.56f) {
        distance_ = -108.69f * voltage_ + 116.08f;
    } else if (voltage_ > 0.51f) {
        distance_ = -106.38f * voltage_ + 114.78f;
    } else if (voltage_ > 0.47f) {
        distance_ = -121.95f * voltage_ + 122.80f;
    } else if (voltage_ > 0.44f) {
        distance_ = -185.18f * voltage_ + 152.77f;
    } else if (voltage_ > 0.43f) {
        distance_ = -333.33f * voltage_ + 219.00f;
    } else {
        distance_ = 99.99f;
    }
    return distance_;
}

void IRsensor::startAveraging(uint8_t averaging_range)
{
    bufferSize = averaging_range;
    data = new float[bufferSize];
    thread_averaging_distance.start(callback(this, &IRsensor::threadloop_averaging_distance));
}
void IRsensor::threadloop_averaging_distance()
{
    while(true){
        computeaverage();
    }    
}
void IRsensor::computeaverage()
{
    bufferpoint++;
    getInputvoltage();
    data[bufferpoint % bufferSize] = voltage;
    voltage_sum = 0;
    for(int i = 0;i<bufferSize;i++)
        voltage_sum += data[i];
    voltage_average = voltage_sum / bufferSize;
    distance_average = changeVtoD(voltage_average);
    
}
float IRsensor::getDistance()
{
    return originaldistance;   
}
float IRsensor::get_Averagingdistance()
{
    return distance_average;    
}

float IRsensor::getVoltage()
{
    return voltage;    
}