/** @IR2302.h
 *
 * これはMD(IR2302)のライブラリです
 * @author 梅沢 晄平
 * @date 2021/10/16
 * @note 現在はPwmOutピンのみが使えますが、需要があればすべてのピンで使えるようにしたいと思います
 */

#ifndef IR2302_H
#define IR2302_H

#include "mbed.h"

/** IR2302 
*モータースピードを指定してモーターを動かす　
*サンプルコード :
*@code
#include "mbed.h"
#include "IR2302.h"
IR2302 ir2302(D5,D6);
DigitalOut stop(D13);//非常停止
*
int main() {
*    stop=1;
*    double s;
*    while(1) {
*        s=1.0;
*        ir2302.SetMotorSpeed(s);
*        //wait(0.01);//入れても入れなくても良い
*    }
}
*@endcode    
*/
class IR2302 {

public:
    /** コンストラクタ
     *
     * @param pin_a MDのAと繋がっているピン(例:D5)
     * @param pin_b MDのBと繋がっているピン(例:D6)
     * @attention PwmOutピンのみ対応(例:D0~D15等) mbedのNUCLEO説明ページを参照
     */
    IR2302(PinName pin_a, PinName pin_b);
    
    /** モーター制御関数
     *
     * モータースピードを-1.0~1.0までの範囲で指定するとモーターを回転させる
     * 0<speed<=1  正回転
     * speed=0     停止
     * -1<speed<=0 逆回転
     * その他の値   停止
     * @param speed モータースピード
     */
    void SetMotorSpeed(double speed);

private:
    double speed;
    PwmOut A;
    PwmOut B;

};

#endif
