#include "IR2302.h"

IR2302::IR2302(PinName pin_a, PinName pin_b):
    A(pin_a),B(pin_b)
{
    A.period(1/20000.0);  //周波数設定（20kHz）
    B.period(1/20000.0);  //周波数設定（20kHz）
    speed=0;
}

void IR2302::SetMotorSpeed(double speed)
{
    if((speed>1)||(speed<-1)){
        A=0;
        B=0;
    }else if(speed>0){
        A=0.95*speed;
        B=0;
    }else if(speed<0){
        A=0;
        B=-0.95*speed;
    }else{
        A=0;
        B=0;
    }
}
