

#include "HOSOKIkikou.h"



HOSOKIkikou::HOSOKIkikou(ikarashiMDC *ik1, ikarashiMDC *ik2, ikarashiMDC *ik3, ikarashiMDC *ik4, uint8_t *b1, uint8_t *b2, uint8_t *b3, uint8_t *b4, int *env1, int *env2) : pc(USBTX,USBRX,115200){
    init(ik1, ik2, ik3, ik4, b1, b2, b3, b4, env1, env2);
}

void HOSOKIkikou::init(ikarashiMDC *ik1, ikarashiMDC *ik2, ikarashiMDC *ik3, ikarashiMDC *ik4, uint8_t *b1, uint8_t *b2, uint8_t *b3, uint8_t *b4, int *env1, int *env2){
    ik[0] = ik1; //射出右
    ik[1] = ik2; //射出左
    ik[2] = ik3; //将校
    ik[3] = ik4; //装填
    button[0] = b1; //射出
    button[1] = b2; //上
    button[2] = b3; //下
    button[3] = b4; //装填
    encoder[0] = env1; //将校
    encoder[1] = env2; //装填
    for(int i=0; i<4; i++){
         mspeed[i] = 0;
         if(i < 2) buff[i] = 0;
    }
    injecterFlag = false;
}

void HOSOKIkikou::runAll(float speedIRight, float speedILeft, float speedLoad, float speedLift)
{
    runInjection(speedIRight, speedILeft);
    runLoad(speedLoad);
    runLift(speedLift);
    for(int i=0; i<4; i++){
         pc.printf("%f  ",mspeed[i]);
    }
    pc.printf("\r\n");
}

void HOSOKIkikou::stopAll(){
    //init(NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
    for(int i=0; i<4; i++){
        button[i] = NULL;
        mspeed[i] = 0;
        if(i < 3){
            encoder[i] = NULL;
        }
    }
    injecterFlag = false;
}

void HOSOKIkikou::runInjection(float speedRight, float speedLeft)
{
    ik[0]->setSpeed(mspeed[0]);
    ik[1]->setSpeed(mspeed[1]);
    if(injecterFlag){
        mspeed[0] = speedRight;
        mspeed[1] = speedLeft;
    }else{
        mspeed[0] = 0;
        mspeed[1] = 0;
    }
    
    buff[0] = *button[0] - buff[1];
    buff[1] = *button[0];
    
    if(buff[0] <= 0 || button[0] == NULL){
        return;
    }else{
        injecterFlag = !injecterFlag;
    }
}

void HOSOKIkikou::runLoad(float speed)
{
    
    ik[3]->setSpeed(mspeed[2]);
    if(*button[1] <= 0 && *button[2] <= 0 || button[1] == NULL || button[2] == NULL){
        mspeed[2] = 0;
        return;   
    }else if(*button[1] >= 1){
        mspeed[2] = speed;
    }else if(*button[2] >= 1){
        mspeed[2] = -speed;
    }else{
        mspeed[2] = 0;   
    }
}

void HOSOKIkikou::runLift(float speed)
{
    ik[2]->setSpeed(mspeed[3]);
    if(*button[3] <= 0){
        mspeed[3] = 0;
        return;   
    }else if(*button[3] >= 1 || button[3] == NULL){
        mspeed[3] = speed;
    }else{
        mspeed[3] = 0;   
    }
}

void HOSOKIkikou::checkAllMotorSpeed(float* data_buff){
    data_buff = mspeed;
}
